# Side effects

Even if the functional programming style prefers writing
pure functions without side-effects, sometimes side-effects
are the reason for running the function in the first place.

This section lists the most important functions with
side-effects that are defined in the SCL standard library.

## Printing

::value[Prelude/print, Prelude/printString, Prelude/printError, Prelude/printingToFile]

## References

::value[Prelude/ref, Prelude/getRef, Prelude/:=]

## Mutable arrays

::data[ArrayList/T]
::value[ArrayList/new]
::value[ArrayList/add]
::value[ArrayList/remove]
::value[ArrayList/get]
::value[ArrayList/length]
::value[ArrayList/contains]

::value[ArrayList/iter, ArrayList/for]
::value[ArrayList/mapInPlace]
::value[ArrayList/popUntilEmpty]

## Escaping side-effects

::value[Builtin/runProc]